/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// ANALOG -> myANALOGPinMux0 Pinmux
//

//
// CANA -> myCAN0 Pinmux
//
//
// CANA_RX - GPIO Settings
//
#define GPIO_PIN_CANA_RX 33
#define myCAN0_CANRX_GPIO 33
#define myCAN0_CANRX_PIN_CONFIG GPIO_33_CANA_RX
//
// CANA_TX - GPIO Settings
//
#define GPIO_PIN_CANA_TX 37
#define myCAN0_CANTX_GPIO 37
#define myCAN0_CANTX_PIN_CONFIG GPIO_37_CANA_TX

//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

//
// EPWM2 -> myEPWM2 Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define myEPWM2_EPWMA_GPIO 2
#define myEPWM2_EPWMA_PIN_CONFIG GPIO_2_EPWM2_A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 3
#define myEPWM2_EPWMB_GPIO 3
#define myEPWM2_EPWMB_PIN_CONFIG GPIO_3_EPWM2_B

//
// EPWM3 -> myEPWM3 Pinmux
//
//
// EPWM3_A - GPIO Settings
//
#define GPIO_PIN_EPWM3_A 4
#define myEPWM3_EPWMA_GPIO 4
#define myEPWM3_EPWMA_PIN_CONFIG GPIO_4_EPWM3_A
//
// EPWM3_B - GPIO Settings
//
#define GPIO_PIN_EPWM3_B 5
#define myEPWM3_EPWMB_GPIO 5
#define myEPWM3_EPWMB_PIN_CONFIG GPIO_5_EPWM3_B

//
// EPWM7 -> myEPWM7 Pinmux
//
//
// EPWM7_A - GPIO Settings
//
#define GPIO_PIN_EPWM7_A 12
#define myEPWM7_EPWMA_GPIO 12
#define myEPWM7_EPWMA_PIN_CONFIG GPIO_12_EPWM7_A
//
// EPWM7_B - GPIO Settings
//
#define GPIO_PIN_EPWM7_B 13
#define myEPWM7_EPWMB_GPIO 13
#define myEPWM7_EPWMB_PIN_CONFIG GPIO_13_EPWM7_B
//
// GPIO58 - GPIO Settings
//
#define LED_RED_PIN_GPIO_PIN_CONFIG GPIO_58_GPIO58
//
// GPIO60 - GPIO Settings
//
#define LED_GREEN_PIN_GPIO_PIN_CONFIG GPIO_60_GPIO60
//
// GPIO59 - GPIO Settings
//
#define LED_YELLOW_PIN_GPIO_PIN_CONFIG GPIO_59_GPIO59
//
// GPIO31 - GPIO Settings
//
#define LED_CONTROLCARD1_GPIO_PIN_CONFIG GPIO_31_GPIO31
//
// GPIO34 - GPIO Settings
//
#define LED_CONTROLCARD2_GPIO_PIN_CONFIG GPIO_34_GPIO34
//
// GPIO23 - GPIO Settings
//
#define GATEDRIVE_DISABLE_GPIO_PIN_CONFIG GPIO_23_GPIO23
//
// GPIO44 - GPIO Settings
//
#define RELAY1_OUT_GPIO_PIN_CONFIG GPIO_44_GPIO44
//
// GPIO61 - GPIO Settings
//
#define RELAY2_OUT_GPIO_PIN_CONFIG GPIO_61_GPIO61
//
// GPIO35 - GPIO Settings
//
#define SPARE_GPIO_INPUT1_GPIO_PIN_CONFIG GPIO_35_GPIO35
//
// GPIO54 - GPIO Settings
//
#define SPARE_GPIO_INPUT2_GPIO_PIN_CONFIG GPIO_54_GPIO54
//
// GPIO55 - GPIO Settings
//
#define SPARE_GPIO_OUTPUT1_GPIO_PIN_CONFIG GPIO_55_GPIO55
//
// GPIO57 - GPIO Settings
//
#define SPARE_GPIO_OUTPUT2_GPIO_PIN_CONFIG GPIO_57_GPIO57

//*****************************************************************************
//
// ADC Configurations
//
//*****************************************************************************
#define myADC0_BASE ADCA_BASE
#define myADC0_RESULT_BASE ADCARESULT_BASE
#define myADC0_SIN ADC_SOC_NUMBER0
#define myADC0_FORCE_SIN ADC_FORCE_SOC0
#define myADC0_SAMPLE_WINDOW_SIN 125.00000000000001
#define myADC0_TRIGGER_SOURCE_SIN ADC_TRIGGER_SW_ONLY
#define myADC0_CHANNEL_SIN ADC_CH_ADCIN8
#define myADC0_COS ADC_SOC_NUMBER1
#define myADC0_FORCE_COS ADC_FORCE_SOC1
#define myADC0_SAMPLE_WINDOW_COS 125.00000000000001
#define myADC0_TRIGGER_SOURCE_COS ADC_TRIGGER_SW_ONLY
#define myADC0_CHANNEL_COS ADC_CH_ADCIN9
#define myADC0_NTC ADC_SOC_NUMBER2
#define myADC0_FORCE_NTC ADC_FORCE_SOC2
#define myADC0_SAMPLE_WINDOW_NTC 125.00000000000001
#define myADC0_TRIGGER_SOURCE_NTC ADC_TRIGGER_SW_ONLY
#define myADC0_CHANNEL_NTC ADC_CH_ADCIN14
#define myADC0_SPARE_ADC1 ADC_SOC_NUMBER3
#define myADC0_FORCE_SPARE_ADC1 ADC_FORCE_SOC3
#define myADC0_SAMPLE_WINDOW_SPARE_ADC1 125.00000000000001
#define myADC0_TRIGGER_SOURCE_SPARE_ADC1 ADC_TRIGGER_SW_ONLY
#define myADC0_CHANNEL_SPARE_ADC1 ADC_CH_ADCIN0
#define myADC0_SPARE_ADC2 ADC_SOC_NUMBER4
#define myADC0_FORCE_SPARE_ADC2 ADC_FORCE_SOC4
#define myADC0_SAMPLE_WINDOW_SPARE_ADC2 125.00000000000001
#define myADC0_TRIGGER_SOURCE_SPARE_ADC2 ADC_TRIGGER_SW_ONLY
#define myADC0_CHANNEL_SPARE_ADC2 ADC_CH_ADCIN1
void myADC0_init();

#define myADC1_BASE ADCB_BASE
#define myADC1_RESULT_BASE ADCBRESULT_BASE
#define myADC1_VDC_MEAS ADC_SOC_NUMBER0
#define myADC1_FORCE_VDC_MEAS ADC_FORCE_SOC0
#define myADC1_SAMPLE_WINDOW_VDC_MEAS 125.00000000000001
#define myADC1_TRIGGER_SOURCE_VDC_MEAS ADC_TRIGGER_SW_ONLY
#define myADC1_CHANNEL_VDC_MEAS ADC_CH_ADCIN10
#define myADC1_VU_MEAS ADC_SOC_NUMBER1
#define myADC1_FORCE_VU_MEAS ADC_FORCE_SOC1
#define myADC1_SAMPLE_WINDOW_VU_MEAS 125.00000000000001
#define myADC1_TRIGGER_SOURCE_VU_MEAS ADC_TRIGGER_SW_ONLY
#define myADC1_CHANNEL_VU_MEAS ADC_CH_ADCIN6
#define myADC1_VV_MEAS ADC_SOC_NUMBER2
#define myADC1_FORCE_VV_MEAS ADC_FORCE_SOC2
#define myADC1_SAMPLE_WINDOW_VV_MEAS 125.00000000000001
#define myADC1_TRIGGER_SOURCE_VV_MEAS ADC_TRIGGER_SW_ONLY
#define myADC1_CHANNEL_VV_MEAS ADC_CH_ADCIN8
#define myADC1_VW_MEAS ADC_SOC_NUMBER3
#define myADC1_FORCE_VW_MEAS ADC_FORCE_SOC3
#define myADC1_SAMPLE_WINDOW_VW_MEAS 125.00000000000001
#define myADC1_TRIGGER_SOURCE_VW_MEAS ADC_TRIGGER_SW_ONLY
#define myADC1_CHANNEL_VW_MEAS ADC_CH_ADCIN1
#define myADC1_T_AMB ADC_SOC_NUMBER4
#define myADC1_FORCE_T_AMB ADC_FORCE_SOC4
#define myADC1_SAMPLE_WINDOW_T_AMB 125.00000000000001
#define myADC1_TRIGGER_SOURCE_T_AMB ADC_TRIGGER_SW_ONLY
#define myADC1_CHANNEL_T_AMB ADC_CH_ADCIN0
#define myADC1_AMBIENT_TEMP ADC_SOC_NUMBER5
#define myADC1_FORCE_AMBIENT_TEMP ADC_FORCE_SOC5
#define myADC1_SAMPLE_WINDOW_AMBIENT_TEMP 125.00000000000001
#define myADC1_TRIGGER_SOURCE_AMBIENT_TEMP ADC_TRIGGER_SW_ONLY
#define myADC1_CHANNEL_AMBIENT_TEMP ADC_CH_ADCIN0
#define VU_PPB ADC_PPB_NUMBER2
#define VU_PPB_SOC ADC_SOC_NUMBER1
#define VV_PPB ADC_PPB_NUMBER3
#define VV_PPB_SOC ADC_SOC_NUMBER2
#define VW_PPB ADC_PPB_NUMBER4
#define VW_PPB_SOC ADC_SOC_NUMBER3
void myADC1_init();

#define myADC2_BASE ADCC_BASE
#define myADC2_RESULT_BASE ADCCRESULT_BASE
#define myADC2_IU_MEAS ADC_SOC_NUMBER0
#define myADC2_FORCE_IU_MEAS ADC_FORCE_SOC0
#define myADC2_SAMPLE_WINDOW_IU_MEAS 125.00000000000001
#define myADC2_TRIGGER_SOURCE_IU_MEAS ADC_TRIGGER_SW_ONLY
#define myADC2_CHANNEL_IU_MEAS ADC_CH_ADCIN3
#define myADC2_IV_MEAS ADC_SOC_NUMBER1
#define myADC2_FORCE_IV_MEAS ADC_FORCE_SOC1
#define myADC2_SAMPLE_WINDOW_IV_MEAS 125.00000000000001
#define myADC2_TRIGGER_SOURCE_IV_MEAS ADC_TRIGGER_SW_ONLY
#define myADC2_CHANNEL_IV_MEAS ADC_CH_ADCIN5
#define myADC2_IW_MEAS ADC_SOC_NUMBER2
#define myADC2_FORCE_IW_MEAS ADC_FORCE_SOC2
#define myADC2_SAMPLE_WINDOW_IW_MEAS 125.00000000000001
#define myADC2_TRIGGER_SOURCE_IW_MEAS ADC_TRIGGER_SW_ONLY
#define myADC2_CHANNEL_IW_MEAS ADC_CH_ADCIN7
#define IU_PPB ADC_PPB_NUMBER2
#define IU_PPB_SOC ADC_SOC_NUMBER0
#define IV_PPB ADC_PPB_NUMBER3
#define IV_PPB_SOC ADC_SOC_NUMBER1
#define IW_PPB ADC_PPB_NUMBER4
#define IW_PPB_SOC ADC_SOC_NUMBER2
void myADC2_init();


//*****************************************************************************
//
// ASYSCTL Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// CAN Configurations
//
//*****************************************************************************
#define myCAN0_BASE CANA_BASE

#define myCAN0_MessageObj1_ID 0
#define myCAN0_MessageObj2_ID 0
#define myCAN0_MessageObj3_ID 255
#define myCAN0_MessageObj4_ID 254
#define myCAN0_MessageObj5_ID 253
#define myCAN0_MessageObj6_ID 252
void myCAN0_init();


//*****************************************************************************
//
// CLA Configurations
//
//*****************************************************************************
#define myCLA1_BASE CLA1_BASE

//
// The following are symbols defined in the CLA assembly code
// Including them in the shared header file makes them global
// and the main CPU can make use of them.
//
__attribute__((interrupt)) void Cla1Task1();
void myCLA1_init();


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define myEPWM1_BASE EPWM1_BASE
#define myEPWM1_TBPRD 0
#define myEPWM1_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM1_TBPHS 0
#define myEPWM1_CMPA 0
#define myEPWM1_CMPB 0
#define myEPWM1_CMPC 0
#define myEPWM1_CMPD 0
#define myEPWM1_DBRED 0
#define myEPWM1_DBFED 0
#define myEPWM1_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM1_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM1_OSHT_SOURCES EPWM_TZ_SIGNAL_DCAEVT1
#define myEPWM1_TZ_INTERRUPT_SOURCES EPWM_TZ_INTERRUPT_DCAEVT1
#define myEPWM1_INTERRUPT_SOURCE EPWM_INT_TBCTR_ZERO
#define myEPWM2_BASE EPWM2_BASE
#define myEPWM2_TBPRD 0
#define myEPWM2_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM2_TBPHS 0
#define myEPWM2_CMPA 0
#define myEPWM2_CMPB 0
#define myEPWM2_CMPC 0
#define myEPWM2_CMPD 0
#define myEPWM2_DBRED 0
#define myEPWM2_DBFED 0
#define myEPWM2_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM2_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM2_OSHT_SOURCES EPWM_TZ_SIGNAL_DCAEVT1
#define myEPWM2_TZ_INTERRUPT_SOURCES EPWM_TZ_INTERRUPT_DCAEVT1
#define myEPWM2_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define myEPWM3_BASE EPWM3_BASE
#define myEPWM3_TBPRD 0
#define myEPWM3_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM3_TBPHS 0
#define myEPWM3_CMPA 0
#define myEPWM3_CMPB 0
#define myEPWM3_CMPC 0
#define myEPWM3_CMPD 0
#define myEPWM3_DBRED 0
#define myEPWM3_DBFED 0
#define myEPWM3_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM3_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM3_OSHT_SOURCES EPWM_TZ_SIGNAL_DCAEVT1
#define myEPWM3_TZ_INTERRUPT_SOURCES EPWM_TZ_INTERRUPT_DCAEVT1
#define myEPWM3_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define myEPWM7_BASE EPWM7_BASE
#define myEPWM7_TBPRD 0
#define myEPWM7_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM7_TBPHS 0
#define myEPWM7_CMPA 0
#define myEPWM7_CMPB 0
#define myEPWM7_CMPC 0
#define myEPWM7_CMPD 0
#define myEPWM7_DBRED 0
#define myEPWM7_DBFED 0
#define myEPWM7_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM7_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM7_OSHT_SOURCES EPWM_TZ_SIGNAL_DCAEVT1
#define myEPWM7_TZ_INTERRUPT_SOURCES EPWM_TZ_INTERRUPT_DCAEVT1
#define myEPWM7_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED

//*****************************************************************************
//
// EPWMXBAR Configurations
//
//*****************************************************************************
void myEPWMXBAR0_init();
#define myEPWMXBAR0 XBAR_TRIP4
#define myEPWMXBAR0_ENABLED_MUXES (XBAR_MUX02 | XBAR_MUX04 | XBAR_MUX06)

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
#define LED_RED_PIN 58
void LED_RED_PIN_init();
#define LED_GREEN_PIN 60
void LED_GREEN_PIN_init();
#define LED_YELLOW_PIN 59
void LED_YELLOW_PIN_init();
#define LED_CONTROLCARD1 31
void LED_CONTROLCARD1_init();
#define LED_CONTROLCARD2 34
void LED_CONTROLCARD2_init();
#define GATEDRIVE_DISABLE 23
void GATEDRIVE_DISABLE_init();
#define RELAY1_OUT 44
void RELAY1_OUT_init();
#define RELAY2_OUT 61
void RELAY2_OUT_init();
#define SPARE_GPIO_INPUT1 35
void SPARE_GPIO_INPUT1_init();
#define SPARE_GPIO_INPUT2 54
void SPARE_GPIO_INPUT2_init();
#define SPARE_GPIO_OUTPUT1 55
void SPARE_GPIO_OUTPUT1_init();
#define SPARE_GPIO_OUTPUT2 57
void SPARE_GPIO_OUTPUT2_init();

//*****************************************************************************
//
// INPUTXBAR Configurations
//
//*****************************************************************************
#define myINPUTXBARINPUT0_SOURCE 8
#define myINPUTXBARINPUT0_INPUT XBAR_INPUT7
void myINPUTXBARINPUT0_init();

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for INT_myCLA11
// ISR need to be defined for the registered interrupts
#define INT_myCLA11 INT_CLA1_1
#define INT_myCLA11_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP11
extern __interrupt void cla1Isr1(void);

//*****************************************************************************
//
// MEMCFG Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// SYNC Scheme Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	ADC_init();
void	ASYSCTL_init();
void	CAN_init();
void	CLA_init();
void	EPWM_init();
void	EPWMXBAR_init();
void	GPIO_init();
void	INPUTXBAR_init();
void	INTERRUPT_init();
void	MEMCFG_init();
void	SYNC_init();
void	PinMux_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
