
//#############################################################################
//
// FILE:    CRD25DA12N-FMC.h (Wolfspeed Primary CRD25DA12N-FMC Header)
//
// TITLE:   CRD25DA12N-FMC 25 kW Controller Code
//
// AUTHOR:  WOLFSPEED
//
// PURPOSE:
//  Header for main function of CRD25DA12N-FMC reference design code. Define
//  variables and functions used in main.
//
//#############################################################################

//
// Header Guards
//
#ifndef WSMAIN
#define WSMAIN

//
// Include Files
//
#include "driverlib.h"
#include "device.h"
#include "board.h"
#include "math.h"                           // standard C math functions
#include "wsinclude\wsgpio.h"               // GPIO pin control
#include "wsinclude\wssensor.h"             // voltage & current sensors
#include "wsinclude\wscan.h"                // CAN communication
#include "wsinclude\wsepwm.h"               // Enhanced PWM control
#include "CRD25DA12N-FMC_shared.h"          // CLA shared functions/variables

//
// Globals
//
float       angleStep;                      // [radians] phase angle step size
float       modulationFactor;               // [unitless, 0-1] output sine wave modulation factor
float       epwmAngles[NUMPHASES];          // [radians] phase angles
float       currentUBuffer[BUFFERSIZE];     // [A] Iu measurement buffer for plotting vs time
float       currentVBuffer[BUFFERSIZE];     // [A] Iv measurement buffer for plotting vs time
float       currentWBuffer[BUFFERSIZE];     // [A] Iw measurement buffer for plotting vs time
float       sensor2Sums[NUMAVGSENSORS]  = {0,0,0,0,0,0};    // [A^2, V^2] cumulative sum of sensor mesaurements squared
float       sensorRms[NUMAVGSENSORS];       // [A, V] RMS value of sensor measurement buffers
float       switchingFreq;                  // [Hz] switching frequency
uint16_t    deadTime;                       // [ns] dead time
uint16_t    fundamentalFreq;                // [Hz] fundamental/line frequency
uint16_t    rmsAvgBins;                     // [-] # of switching periods in RMSAVERAGE # of fund periods
uint16_t    bufferIndex;                    // [-] index counter for tracking ADC storage buffer
uint16_t    epwmTimebasePeriod;             // [s] Enhanced PWM (EPWM) period
uint16_t    rmsIndex = 0;                   // [-] index counter for tracking number of RMS data points
uint16_t    currentSensorNum = 0;           // [-] counter for cycling through current sensors

//
// CLA Task 1 Variables - CPU to CLA
//
#pragma DATA_SECTION(epwmTimebasePeriod,"CpuToCla1MsgRAM");
uint16_t epwmTimebasePeriod;                // [clock cycles] Enhanced PWM (EPWM) period
#pragma DATA_SECTION(modulationFactor,"CpuToCla1MsgRAM");
float modulationFactor;                     // [unitless, 0-1]
#pragma DATA_SECTION(epwmAngles,"CpuToCla1MsgRAM");
float epwmAngles[NUMPHASES];                // [radians] phase angles

//
// Interrupt Function Prototypes
//
__interrupt void epwm1ISR(void);
__interrupt void cla1Isr1(void);

#endif
//
// End of file
//
